Scriptname _SLSubmitBullyEffect extends activemagiceffect  

_SLSubmitConfig Property _SLConfig Auto
_SLSubmitScene Property _SLScene Auto
ReferenceAlias Property ActorBully  Auto  
Spell Property _SLSubmitBully Auto
Spell Property _SLSubmitBullyCloak Auto
Actor Property PlayerRef Auto

event OnEffectStart(actor target, actor caster)
	If (_SLConfig.debugActive)
		debug.Notification("Make your escape before your assailants notice!")
	EndIf
endEvent

Event OnCombatStateChanged(Actor akTarget, int aeCombatState)
	If (aeCombatState == 1)
		_SLScene.WRT(1.0)
		PlayerRef.DispelSpell(_SLSubmitBully)
	EndIf
EndEvent

Event OnObjectEquipped(Form akBaseObject, ObjectReference akReference)
	_SLScene.WRT(1.0)
	PlayerRef.DispelSpell(_SLSubmitBully)
EndEvent

Event OnItemAdded(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akDestContainer)
	_SLScene.WRT(1.0)
	PlayerRef.DispelSpell(_SLSubmitBully)
EndEvent

Event OnEffectFinish(actor Target, actor Caster)
	If (ActorBully.GetActorRef() != none && ActorBully.GetActorRef().Is3DLoaded())
		_SLSubmitBullyCloak.Cast(PlayerRef)
		If (_SLConfig.debugActive)
			debug.Notification("Your recent assailants now have an evil gleam in their eye!")
		EndIf
		ActorBully.Clear()
	EndIf
EndEvent